/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.jei;

import java.util.Collections;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import reliquary.Reliquary;
import reliquary.compat.jei.ItemDescriptionBuilder;
import reliquary.compat.jei.MobCharmRecipeMaker;
import reliquary.compat.jei.SortedNbtSubtypeInterpreter;
import reliquary.compat.jei.SpawnEggRecipeMaker;
import reliquary.compat.jei.alkahestry.AlkahestryChargingRecipeCategory;
import reliquary.compat.jei.alkahestry.AlkahestryCraftingRecipeCategory;
import reliquary.compat.jei.cauldron.CauldronRecipeCategory;
import reliquary.compat.jei.cauldron.CauldronRecipeMaker;
import reliquary.compat.jei.infernaltear.InfernalTearRecipeCategory;
import reliquary.compat.jei.infernaltear.InfernalTearRecipeMaker;
import reliquary.compat.jei.lingering.ArrowShotRecipeMaker;
import reliquary.compat.jei.magazines.MagazineRecipeMaker;
import reliquary.compat.jei.mortar.MortarRecipeCategory;
import reliquary.compat.jei.mortar.MortarRecipeMaker;
import reliquary.crafting.AlkahestryRecipeRegistry;
import reliquary.init.ModBlocks;
import reliquary.init.ModItems;
import reliquary.items.MobCharmFragmentItem;
import reliquary.reference.Settings;

@JeiPlugin
public class ReliquaryPlugin
implements IModPlugin {
    private static final String EFFECTS_TAG = "effects";

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        this.registerNbtSubtypeInterpreter(registration, (Item)ModItems.MOB_CHARM_FRAGMENT.get(), "entity");
        this.registerNbtSubtypeInterpreter(registration, (Item)ModItems.MOB_CHARM.get(), "entity");
        if (Boolean.FALSE.equals(Settings.COMMON.disable.disablePotions.get())) {
            this.registerNbtSubtypeInterpreter(registration, (Item)ModItems.POTION_ESSENCE.get(), EFFECTS_TAG);
            this.registerNbtSubtypeInterpreter(registration, (Item)ModItems.POTION.get(), EFFECTS_TAG);
            this.registerNbtSubtypeInterpreter(registration, (Item)ModItems.SPLASH_POTION.get(), EFFECTS_TAG);
            this.registerNbtSubtypeInterpreter(registration, (Item)ModItems.LINGERING_POTION.get(), EFFECTS_TAG);
            this.registerNbtSubtypeInterpreter(registration, (Item)ModItems.TIPPED_ARROW.get(), EFFECTS_TAG);
            this.registerNbtSubtypeInterpreter(registration, (Item)ModItems.NEUTRAL_BULLET.get(), EFFECTS_TAG);
            this.registerNbtSubtypeInterpreter(registration, (Item)ModItems.NEUTRAL_MAGAZINE.get(), EFFECTS_TAG);
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        if (Boolean.FALSE.equals(Settings.COMMON.disable.disableAlkahestry.get())) {
            registration.addRecipeCategories(new IRecipeCategory[]{new AlkahestryCraftingRecipeCategory(guiHelper)});
            registration.addRecipeCategories(new IRecipeCategory[]{new AlkahestryChargingRecipeCategory(guiHelper)});
        }
        if (Boolean.FALSE.equals(Settings.COMMON.disable.disablePotions.get())) {
            registration.addRecipeCategories(new IRecipeCategory[]{new MortarRecipeCategory(guiHelper)});
            registration.addRecipeCategories(new IRecipeCategory[]{new CauldronRecipeCategory(guiHelper)});
        }
        registration.addRecipeCategories(new IRecipeCategory[]{new InfernalTearRecipeCategory(guiHelper)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50091_), new ResourceLocation[]{AlkahestryChargingRecipeCategory.UID, AlkahestryCraftingRecipeCategory.UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.APOTHECARY_MORTAR.get()), new ResourceLocation[]{MortarRecipeCategory.UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.APOTHECARY_CAULDRON.get()), new ResourceLocation[]{CauldronRecipeCategory.UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.INFERNAL_TEAR.get()), new ResourceLocation[]{InfernalTearRecipeCategory.UID});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        if (Boolean.FALSE.equals(Settings.COMMON.disable.disableAlkahestry.get())) {
            registration.addRecipes(AlkahestryRecipeRegistry.getCraftingRecipes(), AlkahestryCraftingRecipeCategory.UID);
            registration.addRecipes(AlkahestryRecipeRegistry.getChargingRecipes(), AlkahestryChargingRecipeCategory.UID);
        }
        if (Boolean.FALSE.equals(Settings.COMMON.disable.disablePotions.get())) {
            registration.addRecipes(MortarRecipeMaker.getRecipes(), MortarRecipeCategory.UID);
            registration.addRecipes(CauldronRecipeMaker.getRecipes(), CauldronRecipeCategory.UID);
            registration.addRecipes(ArrowShotRecipeMaker.getRecipes(new ItemStack((ItemLike)ModItems.TIPPED_ARROW.get()), new ItemStack((ItemLike)Items.f_42412_), 0.125f, "arrow"), VanillaRecipeCategoryUid.CRAFTING);
            registration.addRecipes(ArrowShotRecipeMaker.getRecipes(new ItemStack((ItemLike)ModItems.NEUTRAL_BULLET.get()), "bullet"), VanillaRecipeCategoryUid.CRAFTING);
        }
        if (Boolean.FALSE.equals(Settings.COMMON.disable.disableHandgun.get())) {
            registration.addRecipes(MagazineRecipeMaker.getRecipes(), VanillaRecipeCategoryUid.CRAFTING);
        }
        registration.addRecipes(MobCharmRecipeMaker.getRecipes(), VanillaRecipeCategoryUid.CRAFTING);
        if (Boolean.FALSE.equals(Settings.COMMON.disable.disableSpawnEggRecipes.get())) {
            registration.addRecipes(SpawnEggRecipeMaker.getRecipes(), VanillaRecipeCategoryUid.CRAFTING);
        }
        registration.addRecipes(InfernalTearRecipeMaker.getRecipes(), InfernalTearRecipeCategory.UID);
        this.registerMobCharmBeltRecipe(registration);
        ItemDescriptionBuilder.addIngredientInfo(registration);
    }

    private void registerMobCharmBeltRecipe(IRecipeRegistration registration) {
        NonNullList fragments = NonNullList.m_122779_();
        ((MobCharmFragmentItem)ModItems.MOB_CHARM_FRAGMENT.get()).m_6787_(Reliquary.ITEM_GROUP, (NonNullList<ItemStack>)fragments);
        ItemStack[] fragmentStacks = (ItemStack[])fragments.toArray((Object[])new ItemStack[0]);
        registration.addRecipes(Collections.singleton(new ShapedRecipe(new ResourceLocation("reliquary", "items/mob_charm_belt"), "", 3, 3, NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{() -> Items.f_42454_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{() -> Items.f_42454_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{() -> Items.f_42454_}), Ingredient.m_43927_((ItemStack[])fragmentStacks), Ingredient.f_43901_, Ingredient.m_43927_((ItemStack[])fragmentStacks), Ingredient.m_43927_((ItemStack[])fragmentStacks), Ingredient.m_43927_((ItemStack[])fragmentStacks), Ingredient.m_43927_((ItemStack[])fragmentStacks)}), new ItemStack((ItemLike)ModItems.MOB_CHARM_BELT.get()))), VanillaRecipeCategoryUid.CRAFTING);
    }

    private void registerNbtSubtypeInterpreter(ISubtypeRegistration registration, Item item, String ... keys) {
        registration.registerSubtypeInterpreter(item, (IIngredientSubtypeInterpreter)new SortedNbtSubtypeInterpreter(keys));
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("reliquary", "default");
    }
}

